<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Auth</title>
    <link rel="stylesheet" href="public/css/style.css">
    <style>
        body { font-family: sans-serif; padding: 20px; }
        .container { max-width: 800px; margin: 0 auto; }
        nav { background: #f4f4f4; padding: 10px; margin-bottom: 20px; }
        nav a { margin-right: 15px; text-decoration: none; color: #333; }
        .alert { padding: 10px; margin-bottom: 10px; border-radius: 5px; }
        .alert-error { background: #f8d7da; color: #721c24; }
        .alert-success { background: #d4edda; color: #155724; }
        form { margin-top: 20px; }
        label { display: block; margin-bottom: 5px; }
        input { width: 100%; padding: 8px; margin-bottom: 10px; box-sizing: border-box; }
        button { padding: 10px 15px; background: #007bff; color: white; border: none; cursor: pointer; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
<div class="container">
    <nav>
        <?php if (Auth::check()): ?>
            <a href="dashboard.php">Dashboard</a>
            <?php if (Auth::hasRole('admin')): ?>
                <a href="admin.php">Admin</a>
            <?php endif; ?>
            <a href="logout.php" style="float: right;">Sair (<?= Auth::user()->username ?>)</a>
        <?php else: ?>
            <a href="login.php">Login</a>
            <a href="register.php">Registrar</a>
        <?php endif; ?>
    </nav>
