<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users');

$db = Database::getInstance()->getConnection();

$id = $_GET['id'] ?? null;
if (!$id) {
    header('Location: users.php');
    exit;
}

$user = new User();
$user = $user->findById($id);

if (!$user) {
    echo "Usuário não encontrado.";
    exit;
}

// Security Check: Protect Super Admin and Admin from lower level modification
$currentUser = Auth::user();
$targetUserRoles = $user->getRoles();
$isCurrentUserSuperAdmin = in_array('super_admin', $currentUser->getRoles());

// If target is Super Admin, only Super Admin can edit
if (in_array('super_admin', $targetUserRoles) && !$isCurrentUserSuperAdmin) {
    header('HTTP/1.0 403 Forbidden');
    echo "Acesso negado. Você não pode editar um Super Administrador.";
    exit;
}

// If target is Admin, only Super Admin can edit (based on user request: "users admin cannot edit permissions of super_admin or admin")
// This implies admins cannot edit other admins.
if (in_array('admin', $targetUserRoles) && !$isCurrentUserSuperAdmin) {
    header('HTTP/1.0 403 Forbidden');
    echo "Acesso negado. Você não pode editar um Administrador.";
    exit;
}

$error = '';
$success = '';

// Buscar todas as roles disponíveis
$stmt = $db->query("SELECT * FROM roles");
$allRoles = $stmt->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $email = $_POST['email'] ?? '';
    $selectedRoles = $_POST['roles'] ?? []; // Array de IDs das roles

    if (empty($username) || empty($email)) {
        $error = "Nome e Email são obrigatórios.";
    } else {
        // Atualizar dados básicos
        if ($user->update($username, $email)) {
            // Atualizar roles
            if ($user->syncRoles($selectedRoles)) {
                $_SESSION['success'] = "Usuário atualizado com sucesso!";
                header('Location: users.php');
                exit;
            } else {
                $error = "Erro ao atualizar roles.";
            }
        } else {
            $error = "Erro ao atualizar usuário.";
        }
    }
}
?>
<?php include 'views/partials/header.php'; ?>

<h2>Editar Usuário: <?= htmlspecialchars($user->username) ?></h2>

<?php if ($error): ?>
    <div class="alert alert-error"><?= $error ?></div>
<?php endif; ?>

<form method="POST" action="">
    <label>Nome:</label>
    <input type="text" name="username" value="<?= htmlspecialchars($user->username) ?>" required>
    
    <label>Email:</label>
    <input type="email" name="email" value="<?= htmlspecialchars($user->email) ?>" required>
    
    <h3>Roles (Papéis)</h3>
    <p>As permissões são concedidas através dos papéis.</p>
    
    <?php 
    $userRoles = $user->getRoles(); // Array de NOMES de roles
    // Precisamos saber quais IDs de roles o usuário tem.
    // O método getRoles() retorna nomes. Vamos fazer uma query rápida ou melhorar o User.php?
    // User::getRoles() returns strings (names).
    // $allRoles contains ['id', 'name', ...].
    // We can map names back to check checkboxes.
    ?>
    
    <?php foreach ($allRoles as $role): // Filter roles: Hide super_admin and admin if current user is not super_admin
    // This prevents privilege escalation by assigning high roles
    if (!$isCurrentUserSuperAdmin && in_array($role['name'], ['super_admin', 'admin'])) {
        continue;
    }
    ?>
    
    <div style="margin-bottom: 5px;">
            <label style="display: inline;">
                <input type="checkbox" name="roles[]" value="<?= $role['id'] ?>" 
                    <?= in_array($role['name'], $userRoles) ? 'checked' : '' ?> 
                    style="width: auto;">
                <?= htmlspecialchars($role['name']) ?>
            </label>
        </div>
    <?php endforeach; ?>
    
    <div style="margin-top: 20px;">
        <h3>Permissões Atuais (Derivadas das Roles)</h3>
        <ul>
            <?php foreach ($user->getPermissions() as $perm): ?>
                <li><?= htmlspecialchars($perm) ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
    
    <button type="submit" style="margin-top: 20px;">Salvar Alterações</button>
</form>

<div style="margin-top: 20px;">
    <a href="users.php">Voltar para Lista</a>
</div>

<?php include 'views/partials/footer.php'; ?>
