<?php

class User {
    private $db;
    public $id;
    public $username;
    public $email;
    public $password;
    private $roles = [];
    private $permissions = [];

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public function findByEmail($email) {
        $stmt = $this->db->prepare("SELECT * FROM users WHERE email = :email LIMIT 1");
        $stmt->execute(['email' => $email]);
        $user = $stmt->fetch();
        if ($user) {
            $this->id = $user['id'];
            $this->username = $user['username'];
            $this->email = $user['email'];
            $this->password = $user['password'];
            $this->loadRolesAndPermissions();
            return $this;
        }
        return null;
    }

    public function findById($id) {
        $stmt = $this->db->prepare("SELECT * FROM users WHERE id = :id LIMIT 1");
        $stmt->execute(['id' => $id]);
        $user = $stmt->fetch();
        if ($user) {
            $this->id = $user['id'];
            $this->username = $user['username'];
            $this->email = $user['email'];
            $this->password = $user['password'];
            $this->loadRolesAndPermissions();
            return $this;
        }
        return null;
    }

    public function create($username, $email, $password) {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $this->db->prepare("INSERT INTO users (username, email, password) VALUES (:username, :email, :password)");
        try {
            $stmt->execute(['username' => $username, 'email' => $email, 'password' => $hash]);
            $this->id = $this->db->lastInsertId();
            
            // Atribuir role padrão 'user'
            $roleStmt = $this->db->prepare("SELECT id FROM roles WHERE name = 'user'");
            $roleStmt->execute();
            $role = $roleStmt->fetch();
            
            if ($role) {
                $assignStmt = $this->db->prepare("INSERT INTO user_roles (user_id, role_id) VALUES (:user_id, :role_id)");
                $assignStmt->execute(['user_id' => $this->id, 'role_id' => $role['id']]);
            }

            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function update($username, $email) {
        try {
            $stmt = $this->db->prepare("UPDATE users SET username = :username, email = :email WHERE id = :id");
            $stmt->execute(['username' => $username, 'email' => $email, 'id' => $this->id]);
            $this->username = $username;
            $this->email = $email;
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function syncRoles($roleIds) {
        try {
            $this->db->beginTransaction();
            
            // Remover roles atuais
            $stmt = $this->db->prepare("DELETE FROM user_roles WHERE user_id = :user_id");
            $stmt->execute(['user_id' => $this->id]);
            
            // Adicionar novas roles
            if (!empty($roleIds)) {
                $insertStmt = $this->db->prepare("INSERT INTO user_roles (user_id, role_id) VALUES (:user_id, :role_id)");
                foreach ($roleIds as $roleId) {
                    $insertStmt->execute(['user_id' => $this->id, 'role_id' => $roleId]);
                }
            }
            
            $this->db->commit();
            $this->loadRolesAndPermissions(); // Recarregar
            return true;
        } catch (PDOException $e) {
            $this->db->rollBack();
            return false;
        }
    }

    public static function getAll() {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->query("SELECT * FROM users");
        $users = [];
        while ($row = $stmt->fetch()) {
            $user = new User();
            $user->id = $row['id'];
            $user->username = $row['username'];
            $user->email = $row['email'];
            $user->password = $row['password'];
            $user->loadRolesAndPermissions();
            $users[] = $user;
        }
        return $users;
    }

    private function loadRolesAndPermissions() {
        // Carregar Roles
        $stmt = $this->db->prepare("
            SELECT r.name 
            FROM roles r 
            JOIN user_roles ur ON r.id = ur.role_id 
            WHERE ur.user_id = :user_id
        ");
        $stmt->execute(['user_id' => $this->id]);
        $this->roles = $stmt->fetchAll(PDO::FETCH_COLUMN);

        // Carregar Permissions (baseado nas roles)
        if (!empty($this->roles)) {
            $placeholders = implode(',', array_fill(0, count($this->roles), '?'));
            $sql = "
                SELECT DISTINCT p.name 
                FROM permissions p 
                JOIN role_permissions rp ON p.id = rp.permission_id 
                JOIN roles r ON rp.role_id = r.id 
                WHERE r.name IN ($placeholders)
            ";
            $stmt = $this->db->prepare($sql);
            $stmt->execute($this->roles);
            $this->permissions = $stmt->fetchAll(PDO::FETCH_COLUMN);
        }
    }

    public function getRoles() {
        return $this->roles;
    }

    public function getPermissions() {
        return $this->permissions;
    }

    public function hasRole($role) {
        return in_array($role, $this->roles);
    }

    public function hasPermission($permission) {
        return in_array($permission, $this->permissions);
    }
}
