<?php

class Permission {
    private $db;
    public $id;
    public $name;
    public $description;
    public $is_exclusive;

    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }

    public static function getAll() {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->query("SELECT * FROM permissions");
        $permissions = [];
        while ($row = $stmt->fetch()) {
            $perm = new Permission();
            $perm->id = $row['id'];
            $perm->name = $row['name'];
            $perm->description = $row['description'];
            $perm->is_exclusive = (bool)$row['is_exclusive'];
            $permissions[] = $perm;
        }
        return $permissions;
    }

    public function findById($id) {
        $stmt = $this->db->prepare("SELECT * FROM permissions WHERE id = :id LIMIT 1");
        $stmt->execute(['id' => $id]);
        $row = $stmt->fetch();
        if ($row) {
            $this->id = $row['id'];
            $this->name = $row['name'];
            $this->description = $row['description'];
            $this->is_exclusive = (bool)$row['is_exclusive'];
            return $this;
        }
        return null;
    }

    public function create($name, $description = '', $is_exclusive = 0) {
        try {
            $stmt = $this->db->prepare("INSERT INTO permissions (name, description, is_exclusive) VALUES (:name, :description, :is_exclusive)");
            $stmt->execute(['name' => $name, 'description' => $description, 'is_exclusive' => $is_exclusive]);
            $this->id = $this->db->lastInsertId();
            $this->name = $name;
            $this->description = $description;
            $this->is_exclusive = (bool)$is_exclusive;
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function update($name, $description = '', $is_exclusive = 0) {
        try {
            $stmt = $this->db->prepare("UPDATE permissions SET name = :name, description = :description, is_exclusive = :is_exclusive WHERE id = :id");
            $stmt->execute(['name' => $name, 'description' => $description, 'is_exclusive' => $is_exclusive, 'id' => $this->id]);
            $this->name = $name;
            $this->description = $description;
            $this->is_exclusive = (bool)$is_exclusive;
            return true;
        } catch (PDOException $e) {
            return false;
        }
    }

    public function delete() {
        try {
            $stmt = $this->db->prepare("DELETE FROM permissions WHERE id = :id");
            return $stmt->execute(['id' => $this->id]);
        } catch (PDOException $e) {
            return false;
        }
    }
}
