<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users');

$id = $_GET['id'] ?? null;
$role = new Role();
$isEdit = false;

if ($id) {
    $role = $role->findById($id);
    if (!$role) {
        echo "Papel não encontrado.";
        exit;
    }
    
    // Security check: Protect super_admin and admin roles from modification by non-super_admins
    if (in_array($role->name, ['admin', 'super_admin']) && !Auth::hasRole('super_admin')) {
        header('HTTP/1.0 403 Forbidden');
        echo "Acesso negado. Você não pode editar este papel.";
        exit;
    }
    
    $isEdit = true;
}

$error = '';
$allPermissions = Permission::getAll();

// Filter exclusive permissions if not super_admin
if (!Auth::hasRole('super_admin')) {
    $allPermissions = array_filter($allPermissions, function($p) {
        return !$p->is_exclusive;
    });
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $description = $_POST['description'] ?? '';
    $selectedPermissions = $_POST['permissions'] ?? [];

    if (empty($name)) {
        $error = "Nome é obrigatório.";
    } else {
        $success = false;
        if ($isEdit) {
            if ($role->update($name, $description)) {
                $role->syncPermissions($selectedPermissions);
                $success = true;
            }
        } else {
            if ($role->create($name, $description)) {
                $role->syncPermissions($selectedPermissions);
                $success = true;
            }
        }

        if ($success) {
            $_SESSION['success'] = "Papel salvo com sucesso!";
            header('Location: roles.php');
            exit;
        } else {
            $error = "Erro ao salvar papel.";
        }
    }
}

$currentPermissions = $isEdit ? $role->getPermissions() : [];
?>
<?php include 'views/partials/header.php'; ?>

<h2><?= $isEdit ? 'Editar Papel' : 'Novo Papel' ?></h2>

<?php if ($error): ?>
    <div class="alert alert-error"><?= $error ?></div>
<?php endif; ?>

<form method="POST" action="">
    <label>Nome:</label>
    <input type="text" name="name" value="<?= htmlspecialchars($role->name ?? '') ?>" required>
    
    <label>Descrição:</label>
    <textarea name="description" style="width: 100%; height: 60px; margin-bottom: 10px;"><?= htmlspecialchars($role->description ?? '') ?></textarea>
    
    <h3>Permissões Associadas</h3>
    <div style="max-height: 300px; overflow-y: auto; border: 1px solid #ddd; padding: 10px;">
        <?php foreach ($allPermissions as $perm): ?>
            <div style="margin-bottom: 5px;">
                <label style="display: inline;">
                    <input type="checkbox" name="permissions[]" value="<?= $perm->id ?>" 
                        <?= in_array($perm->id, $currentPermissions) ? 'checked' : '' ?> 
                        style="width: auto;">
                    <strong><?= htmlspecialchars($perm->name) ?></strong> - <?= htmlspecialchars($perm->description) ?>
                </label>
            </div>
        <?php endforeach; ?>
    </div>
    
    <button type="submit" style="margin-top: 20px;">Salvar</button>
</form>

<div style="margin-top: 20px;">
    <a href="roles.php">Voltar para Lista</a>
</div>

<?php include 'views/partials/footer.php'; ?>
