<?php
require_once 'autoload.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if ($username && $email && $password) {
        $user = new User();
        if ($user->findByEmail($email)) {
            $error = 'Email já cadastrado.';
        } else {
            if ($user->create($username, $email, $password)) {
                $success = 'Registro realizado com sucesso! <a href="login.php">Faça login</a>.';
            } else {
                $error = 'Erro ao registrar usuário.';
            }
        }
    } else {
        $error = 'Preencha todos os campos.';
    }
}
?>
<?php include 'views/partials/header.php'; ?>

<h2>Registrar</h2>

<?php if ($error): ?>
    <div class="alert alert-error"><?= $error ?></div>
<?php endif; ?>
<?php if ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<form method="POST" action="">
    <label>Nome de Usuário:</label>
    <input type="text" name="username" required>

    <label>Email:</label>
    <input type="email" name="email" required>
    
    <label>Senha:</label>
    <input type="password" name="password" required>
    
    <button type="submit">Registrar</button>
</form>

<?php include 'views/partials/footer.php'; ?>
