<?php
require_once 'autoload.php';
Auth::requireLogin();
Auth::requirePermission('manage_users');

$permissions = Permission::getAll();

// Filter exclusive permissions if not super_admin
if (!Auth::hasRole('super_admin')) {
    $permissions = array_filter($permissions, function($p) {
        return !$p->is_exclusive;
    });
}
?>
<?php include 'views/partials/header.php'; ?>

<h2>Gerenciar Permissões</h2>

<?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
    <?php unset($_SESSION['success']); ?>
<?php endif; ?>

<div style="margin-bottom: 20px;">
    <a href="permission_edit.php" class="btn">Criar Nova Permissão</a>
</div>

<table border="1" cellpadding="10" style="width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th>ID</th>
            <th>Nome (Slug)</th>
            <th>Descrição</th>
            <th>Ações</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($permissions as $perm): ?>
        <tr>
            <td><?= $perm->id ?></td>
            <td><?= htmlspecialchars($perm->name) ?></td>
            <td><?= htmlspecialchars($perm->description) ?></td>
            <td>
                <a href="permission_edit.php?id=<?= $perm->id ?>">Editar</a>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<div style="margin-top: 20px;">
    <a href="dashboard.php">Voltar ao Dashboard</a>
</div>

<?php include 'views/partials/footer.php'; ?>
