<?php
require_once 'autoload.php';

$error = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if (Auth::login($email, $password)) {
        header('Location: dashboard.php');
        exit;
    } else {
        $error = true;
    }
}
?>

<html lang="en" data-bs-theme="dark">
	<!--begin::Head-->
	<head><base href="../../../"/>
		<title>Site Mentor Wesley</title>
		<meta charset="utf-8" />
		<meta name="description" content="" />
		<meta name="keywords" content="" />
		<meta name="viewport" content="width=device-width, initial-scale=1" />
		<link rel="shortcut icon" href="public/media/logos/favicon.ico" />
		<!--begin::Fonts(mandatory for all pages)-->
		<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />
		<!--end::Fonts-->
		<!--begin::Global Stylesheets Bundle(mandatory for all pages)-->
		<link href="public/plugins/global/plugins.bundle.css" rel="stylesheet" type="text/css" />
		<link href="public/css/style.bundle.css" rel="stylesheet" type="text/css" />
		<!--end::Global Stylesheets Bundle-->
	</head>
	<!--end::Head-->
	<!--begin::Body-->
	<body id="kt_body" class="app-blank bgi-size-cover bgi-attachment-fixed bgi-position-center bgi-no-repeat">
		<!--begin::Theme mode setup on page load-->
		<script>
			var defaultThemeMode = "dark";
			var themeMode; 
			if ( document.documentElement ) { 
				if ( document.documentElement.hasAttribute("data-bs-theme-mode")) { 
					themeMode = document.documentElement.getAttribute("data-bs-theme-mode"); 
				} else { 
					if ( localStorage.getItem("data-bs-theme") !== null ) { 
						themeMode = localStorage.getItem("data-bs-theme"); 
					} else { 
						themeMode = defaultThemeMode; 
					} 
				}
				document.documentElement.setAttribute("data-bs-theme", themeMode); 
			}
		</script>
		<!--end::Theme mode setup on page load-->
		<!--begin::Root-->
		<div class="d-flex flex-column flex-root" id="kt_app_root">
			<!--begin::Page bg image-->
			<style>body { background-image: url('public/media/bg/bg.jpg'); } [data-bs-theme="dark"] body { background-image: url('public/media/bg/bg.jpg'); }</style>
			<!--end::Page bg image-->
			<!--begin::Authentication - Sign-in -->
			<div class="d-flex flex-column flex-column-fluid flex-lg-row">
				<!--begin::Aside-->
				<div class="d-flex flex-center w-lg-50 pt-15 pt-lg-0 px-10">
					<!--begin::Aside-->
					<div class="d-flex flex-center flex-lg-start flex-column">
						<!--begin::Logo-->
						<a href="" class="mb-7">
							<img alt="Logo" src="public/media/logos/madrugao.png" />
						</a>
						<!--end::Logo-->
					</div>
					<!--begin::Aside-->
				</div>
				<!--begin::Aside-->
				<!--begin::Body-->
				<div class="d-flex flex-column-fluid flex-lg-row-auto justify-content-center justify-content-lg-end p-12 p-lg-20">
					<!--begin::Card-->
					<div class="d-flex flex-column align-items-stretch flex-center rounded-4 w-600px">
						<!--begin::Wrapper-->
						<div class="d-flex flex-center flex-column flex-column-fluid px-lg-10">
							<!--begin::Form-->
							<form class="form w-100 bg-body rounded-4 p-10" method="POST" id="kt_sign_in_form" >
								<!--begin::Alerts-->
								<?php
									 if ($error){
                                        $alert_style = 'danger';
                                        $alert_title = 'Atenção';
                                        $alert_text = 'Email ou senha inválidos!';
                                       
								?>
									<div class="alert alert-<?=$alert_style;?> align-items-center d-flex justify-content-center text-center">
										<!--begin::Wrapper-->
										<div class="d-flex flex-column">
											<!--begin::Title-->
											<h4 class="mb-1 text-<?=$alert_style;?>"><?=$alert_title;?></h4>
											<!--end::Title-->
											<!--begin::Content-->
											<span><?=$alert_text;?></span>
											<!--end::Content-->
										</div>
										<!--end::Wrapper-->
									</div>
								<?php
										
									}
								?>								
								<!--end::Alerts-->
								<!--begin::Heading-->
								<div class="text-center mb-11">
									<!--begin::Title-->
									<h1 class="text-dark fw-bolder mb-3">Login</h1>
									<!--end::Title-->
								</div>
								<!--begin::Heading-->
								<!--begin::Input group=-->								
								<div class="fv-row mb-3">
									<!--begin::Email-->
									<input type="text" placeholder="Email" name="email" autocomplete="off" class="form-control bg-transparent" />
									<!--end::Email-->
								</div>
								<!--end::Input group=-->
								<div class="fv-row mb-8">
									<!--begin::Password-->
									<input type="password" placeholder="Senha" name="password" autocomplete="off" class="form-control bg-transparent" />
									<!--end::Password-->
								</div>
								<!--end::Input group=-->
								<!--begin::Wrapper-->
								<!--<div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">-->
									<!--<div></div>-->
									<!--begin::Link-->
									<!--<a href="reset-password" class="link-primary">Esqueceu a senha?</a>-->
									<!--end::Link-->
								<!--</div>-->
								<!--end::Wrapper-->
								<!--begin::Submit button-->
								<div class="d-grid mb-10">
									<button type="submit" id="kt_sign_in_submit" class="btn btn-primary">
										<!--begin::Indicator label-->
										<span class="indicator-label">Entrar</span>
										<!--end::Indicator label-->
										<!--begin::Indicator progress-->
										<span class="indicator-progress">Aguarde...
										<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
										<!--end::Indicator progress-->
									</button>
								</div>
								<input type="hidden" name="action" value="login">
								<!--end::Submit button-->
								<!--begin::Sign up-->
								<div class="text-gray-500 text-center fw-semibold fs-6">
									<a href="register" class="link-primary">Crie uma conta agora</a>
								</div>
								<!--end::Sign up-->
							</form>
							<!--end::Form-->
						</div>
						<!--end::Wrapper-->
						
					</div>
					<!--end::Card-->
				</div>
				<!--end::Body-->
			</div>
			<!--end::Authentication - Sign-in-->
		</div>
		<!--end::Root-->
		<!--begin::Javascript-->
		<script>var hostUrl = "public/";</script>
		<!--begin::Global Javascript Bundle(mandatory for all pages)-->
		<script src="public/plugins/global/plugins.bundle.js"></script>
		<script src="public/js/scripts.bundle.js"></script>
		<!--end::Global Javascript Bundle-->
		<!--begin::Custom Javascript(used for this page only)-->
		<script src="public/js/custom/authentication/sign-in/general.js"></script>
		<!--end::Custom Javascript-->
		<!--end::Javascript-->
	</body>
	<!--end::Body-->
</html>
