<?php
require_once 'autoload.php';
Auth::requireLogin();

$user = Auth::user();
?>
<?php include 'views/partials/header.php'; ?>

<h2>Dashboard</h2>

<p>Bem-vindo, <strong><?= htmlspecialchars($user->username) ?></strong>!</p>

<div style="background: #fff; padding: 15px; border: 1px solid #ddd; margin-top: 20px;">
    <h3>Suas Informações:</h3>
    <ul>
        <li>Email: <?= htmlspecialchars($user->email) ?></li>
        <li>Roles: <?= implode(', ', $user->getRoles()) ?></li>
        <li>Permissions: <?= implode(', ', $user->getPermissions()) ?></li>
    </ul>
</div>

<div style="margin-top: 20px;">
    <?php if (Auth::hasPermission('manage_users')): ?>
        <a href="users.php" style="display: inline-block; padding: 10px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 5px; margin-right: 10px;">Gerenciar Usuários</a>
        <a href="roles.php" style="display: inline-block; padding: 10px 15px; background: #17a2b8; color: white; text-decoration: none; border-radius: 5px; margin-right: 10px;">Gerenciar Papéis</a>
        <a href="permissions.php" style="display: inline-block; padding: 10px 15px; background: #6c757d; color: white; text-decoration: none; border-radius: 5px;">Gerenciar Permissões</a>
    <?php endif; ?>

    <?php if (Auth::hasPermission('edit_posts')): ?>
        <button onclick="alert('Ação permitida: Editar Posts')">Editar Posts</button>
    <?php endif; ?>
</div>

<?php include 'views/partials/footer.php'; ?>
