# Sistema de Autenticação e Permissões (ACL) em PHP

Este é um sistema simples de autenticação e controle de acesso (ACL) utilizando PHP Puro (sem frameworks e sem Composer), MySQL e POO.

## Estrutura

- `config/`: Configurações do banco de dados.
- `src/`: Classes PHP (User, Auth, Database).
- `views/`: Arquivos de template (header, footer).
- `public/`: Assets (CSS, JS).
- Raiz: Controladores/Views principais (login, register, dashboard, admin).

## Instalação

1.  Crie um banco de dados MySQL chamado `madrugao` (ou outro nome de sua preferência).
2.  Importe o arquivo `database.sql` para criar as tabelas e dados iniciais.
    - O script cria usuários, roles e permissões padrão.
    - Cria um usuário admin: **User:** `admin`, **Senha:** `admin123`.
3.  Configure a conexão no arquivo `config/config.php` se necessário (padrão: localhost, root, sem senha).
4.  Acesse o projeto pelo navegador (ex: `http://localhost/madrugao`).

## Funcionalidades

- **Login/Logout**: Sistema de sessão seguro.
- **Registro**: Novos usuários recebem a role 'user' por padrão.
- **Roles**: 'admin', 'editor', 'user'.
- **Permissions**: 'view_dashboard', 'manage_users', 'edit_posts'.
- **Proteção de Rotas**:
    - `Auth::requireLogin()`: Exige login.
    - `Auth::requireRole('admin')`: Exige papel de administrador.
    - `Auth::requirePermission('edit_posts')`: Exige permissão específica.
- **Interface Dinâmica**: O menu e os botões mudam conforme as permissões do usuário logado.
