from pydantic import BaseModel
from typing import Optional, List
from datetime import datetime

class MatchBase(BaseModel):
    time_casa: str
    time_fora: str

class MatchCreate(MatchBase):
    id_jogo: int
    placar_casa: int
    placar_fora: int
    data_jogo: Optional[datetime] = None

class MatchResponse(MatchCreate):
    class Config:
        from_attributes = True

class PredictionRequest(MatchBase):
    pass

class MarketPrediction(BaseModel):
    probability: float
    should_bet: bool
    confidence: str # "High", "Medium", "Low"
    suggested_odds: Optional[float] = None
    expected_value: Optional[float] = None # EV%
    kelly_stake_pct: Optional[float] = None # Recommended stake % of bankroll

class Winner1x2Prediction(BaseModel):
    home_probability: float
    draw_probability: float
    away_probability: float
    best_bet: str # "HOME", "DRAW", "AWAY" or "SKIP"
    confidence: str
    value_bet: bool = False
    expected_value: Optional[float] = None
    kelly_stake_pct: Optional[float] = None

class CorrectScoreProbability(BaseModel):
    score: str # "1-0"
    probability: float

class MatchPrediction(BaseModel):
    time_casa: str
    time_fora: str
    winner_1x2: Winner1x2Prediction
    over_1_5: MarketPrediction
    over_2_5: MarketPrediction
    over_3_5: MarketPrediction
    btts: MarketPrediction
    correct_score_probabilities: List[CorrectScoreProbability]
    most_likely_score: str
