# Kiron2 - Sistema de Previsão de Futebol Virtual com ML

## Machine Learning Integration

Este sistema agora utiliza **XGBoost** para realizar previsões avançadas.
A arquitetura combina a precisão estatística da Distribuição de Poisson com a capacidade de aprendizado de padrões do Machine Learning.

### Componentes de ML

1.  **Feature Engineering (`app/feature_engineering.py`)**:
    *   Transforma o histórico de partidas em indicadores de performance.
    *   Calcula médias móveis (5 e 10 jogos) de gols feitos, sofridos e pontos.
    *   Analisa a "forma" recente dos times.

2.  **ML Engine (`app/ml_engine.py`)**:
    *   Gerencia modelos **XGBoost**.
    *   **Modelos de Regressão**: Preveem a quantidade exata de gols esperados para o time da casa e visitante.
    *   **Modelo de Classificação**: Prevê a probabilidade de "Ambas Marcam" (BTTS).
    *   Salva os modelos treinados na pasta `models/`.

3.  **Auto-Otimização (`/optimize/`)**:
    *   Endpoint que re-treina todos os modelos com os dados mais recentes do banco de dados.
    *   Deve ser chamado periodicamente (ex: via cron job a cada hora ou dia).

### Como Usar

1.  **Instale as dependências de ML**:
    (Já incluídas no requirements.txt, mas certifique-se de ter `xgboost` e `scikit-learn`)
    ```bash
    pip install xgboost scikit-learn
    ```

2.  **Treine o Modelo Inicialmente**:
    O sistema precisa de um treino inicial. Chame o endpoint:
    ```bash
    curl http://127.0.0.1:8000/optimize/
    ```
    Ou use o script Python:
    ```python
    import requests
    requests.get("http://127.0.0.1:8000/optimize/")
    ```

3.  **Faça Previsões**:
    As previsões agora usarão automaticamente o modelo ML se ele estiver treinado.
    ```bash
    curl "http://127.0.0.1:8000/predict/?time_casa=Manchester%20Blue&time_fora=London%20FC"
    ```

### Arquitetura Híbrida

O sistema usa uma abordagem híbrida inteligente:
*   **ML (XGBoost)**: Prevê os parâmetros `lambda` (expectativa de gols) com base em features complexas.
*   **Poisson**: Usa os `lambda` previstos pelo ML para gerar a matriz de probabilidades exatas (Placar Correto, Over/Under, 1x2).

Isso garante que as probabilidades sejam matematicamente consistentes (ex: a soma das probs de placar exato dá 100%) enquanto aproveita o poder preditivo do ML.
